def cmpnorm(x,y):
    sumsquare_x=x[0]**2+x[1]**2+x[2]**2
    sumsquare_y=y[0]**2+y[1]**2+y[2]**2
    if sumsquare_x < sumsquare_y:
        retval=-1
    elif sumsquare_x > sumsquare_y:
        retval=1
    else:
        retval=0
    return retval

def cmppeak_tth(x,y):
    xcomp=abs(x[1])
    ycomp=abs(y[1])
    if xcomp < ycomp:
        retval=-1
    elif xcomp > ycomp:
        retval=1
    else:
        retval=0
    return retval

def fccpeaks():
    indices=[]
    hklsquared=[]
    for lind in range(15):
        for kind in range(15):
            for hind in range(15):
                squared=hind**2+kind**2+lind**2
                if squared in hklsquared:
                    pass
                else:
                    # hodd, kodd, lodd will be 1 if odd and 0 if even
                    hodd=hind % 2
                    kodd=kind % 2
                    lodd=lind % 2
                    n_hodd=not(hodd)
                    n_kodd=not(kodd)
                    n_lodd=not(lodd)
                    if squared==0:
                        pass
                    elif (hodd & kodd & lodd):
                        # h,k,l are all odd
                        hklsquared.append(squared)
                        indices.append([hind,kind,lind])
                    elif (n_hodd & n_kodd & n_lodd):
                        # h,k,l are all even
                        hklsquared.append(squared)
                        indices.append([hind,kind,lind])
                    else:
                        pass


    indices.sort(cmpnorm)
        
    return indices

def fccpeaks_l2():
    indices=[]
    hklsquared=[]
    for lind in range(15):
        for kind in range(15):
            for hind in range(15):
                squared=hind**2+kind**2+lind**2
                if squared in hklsquared:
                    pass
                else:
                    # hodd, kodd, lodd will be 1 if odd and 0 if even
                    hodd=hind % 2
                    kodd=kind % 2
                    lodd=lind % 2
                    n_hodd=not(hodd)
                    n_kodd=not(kodd)
                    n_lodd=not(lodd)
                    if squared==0:
                        pass
                    elif (hodd & kodd & lodd):
                        # h,k,l are all odd
                        hklsquared.append(squared)
                        indices.append([hind,kind,lind])
                    elif (n_hodd & n_kodd & n_lodd):
                        # h,k,l are all even
                        hklsquared.append(squared)
                        indices.append([hind,kind,lind])
                    else:
                        pass
    l2indices=[]
    for peak in indices:
        squared=((peak[0]/2.0)**2+(peak[1]/2.0)**2+(peak[2]/2.0)**2)
        if squared in hklsquared:
            pass
        else:
            l2indices.append([peak[0]/2.0,peak[1]/2.0,peak[2]/2.0])

    l2indices.sort(cmpnorm)
        
    return l2indices

def bccpeaks():
    indices=[]
    hklsquared=[]
    for lind in range(15):
        for kind in range(15):
            for hind in range(15):
                squared=hind**2+kind**2+lind**2
                if squared in hklsquared:
                    pass
                else:
                    # hodd, kodd, lodd will be 1 if odd and 0 if even
                    hklsum=hind+kind+lind
                    if hklsum == 0:
                        pass
                    elif (hklsum % 2):
                        # hklsum is odd
                        pass
                    else:
                        #hklsum is even
                        hklsquared.append(squared)
                        indices.append([hind,kind,lind])
    indices.sort(cmpnorm)                     
    return indices

def bccpeaks_l2():
    indices=[]
    hklsquared=[]
    for lind in range(15):
        for kind in range(15):
            for hind in range(15):
                squared=hind**2+kind**2+lind**2
                if squared in hklsquared:
                    pass
                else:
                    # hodd, kodd, lodd will be 1 if odd and 0 if even
                    hklsum=hind+kind+lind
                    if hklsum == 0:
                        pass
                    elif (hklsum % 2):
                        # hklsum is odd
                        pass
                    else:
                        #hklsum is even
                        hklsquared.append(squared)
                        indices.append([hind,kind,lind])
    l2indices=[]
    for peak in indices:
        squared=((peak[0]/2.0)**2+(peak[1]/2.0)**2+(peak[2]/2.0)**2)
        if squared in hklsquared:
            pass
        else:
            l2indices.append([peak[0]/2.0,peak[1]/2.0,peak[2]/2.0])

    l2indices.sort(cmpnorm)
        
    return l2indices
    
def diamondpeaks():
    indices=[]
    hklsquared=[]
    for lind in range(15):
        for kind in range(15):
            for hind in range(15):
                squared=hind**2+kind**2+lind**2
                if squared in hklsquared:
                    pass
                else:
                    # hodd, kodd, lodd will be 1 if odd and 0 if even
                    hodd=hind % 2
                    kodd=kind % 2
                    lodd=lind % 2
                    n_hodd=not(hodd)
                    n_kodd=not(kodd)
                    n_lodd=not(lodd)
                    if squared==0:
                        pass
                    elif (hodd & kodd & lodd):
                        # h,k,l are all odd
                        hklsquared.append(squared)
                        indices.append([hind,kind,lind])
                    elif (n_hodd & n_kodd & n_lodd):
                        # h,k,l are all even
                        if (((hind+kind+lind) % 4)==0):
                            # check to see if h+k+l=4n where n is an integer
                            hklsquared.append(squared)
                            indices.append([hind,kind,lind])
                    else:
                        pass
    
    indices.sort(cmpnorm)
    return indices

def diamondpeaks_l2():
    indices=[]
    hklsquared=[]
    for lind in range(15):
        for kind in range(15):
            for hind in range(15):
                squared=hind**2+kind**2+lind**2
                if squared in hklsquared:
                    pass
                else:
                    # hodd, kodd, lodd will be 1 if odd and 0 if even
                    hodd=hind % 2
                    kodd=kind % 2
                    lodd=lind % 2
                    n_hodd=not(hodd)
                    n_kodd=not(kodd)
                    n_lodd=not(lodd)
                    if squared==0:
                        pass
                    elif (hodd & kodd & lodd):
                        # h,k,l are all odd
                        hklsquared.append(squared)
                        indices.append([hind,kind,lind])
                    elif (n_hodd & n_kodd & n_lodd):
                        # h,k,l are all even
                        if (((hind+kind+lind) % 4)==0):
                            # check to see if h+k+l=4n where n is an integer
                            hklsquared.append(squared)
                            indices.append([hind,kind,lind])
                    else:
                        pass
    
    l2indices=[]
    for peak in indices:
        squared=((peak[0]/2.0)**2+(peak[1]/2.0)**2+(peak[2]/2.0)**2)
        if squared in hklsquared:
            pass
        else:
            l2indices.append([peak[0]/2.0,peak[1]/2.0,peak[2]/2.0])

    l2indices.sort(cmpnorm)
        
    return l2indices